/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines;

import com.sun.j3d.audioengines.AudioEngine;
import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.Sample;
import java.util.ArrayList;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public abstract class AudioEngine3D
extends AudioEngine
implements AudioDevice3D {
    protected ArrayList samples = new ArrayList(64);
    protected View currentView = null;
    protected AuralParameters attribs = new AuralParameters();

    public AudioEngine3D(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    public void setView(View view) {
        this.currentView = view;
    }

    public View getView() {
        return this.currentView;
    }

    public int prepareSound(int n2, MediaContainer mediaContainer) {
        return -1;
    }

    public abstract void clearSound(int var1);

    public void setVworldXfrm(int n2, Transform3D transform3D) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            sample.vworldXfrm.set(transform3D);
        }
    }

    public abstract int startSample(int var1);

    public abstract int stopSample(int var1);

    public abstract void updateSample(int var1);

    public abstract void muteSample(int var1);

    public abstract void unmuteSample(int var1);

    public abstract void pauseSample(int var1);

    public abstract void unpauseSample(int var1);

    public void setSampleGain(int n2, float f2) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            sample.setGain(f2);
        }
    }

    public void setLoop(int n2, int n3) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            sample.setLoopCount(n3);
        }
    }

    public void setPosition(int n2, Point3d point3d) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            sample.setPosition(point3d);
        }
    }

    public void setDistanceGain(int n2, double[] dArray, float[] fArray, double[] dArray2, float[] fArray2) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            sample.setDistanceGain(dArray, fArray, dArray2, fArray2);
        }
    }

    public void setDirection(int n2, Vector3d vector3d) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            sample.setDirection(vector3d);
        }
    }

    public void setAngularAttenuation(int n2, int n3, double[] dArray, float[] fArray, float[] fArray2) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            sample.setAngularAttenuation(n3, dArray, fArray, fArray2);
        }
    }

    public void setRolloff(float f2) {
        this.attribs.rolloff = f2;
    }

    public void setReflectionCoefficient(float f2) {
        this.attribs.reflectionCoefficient = f2;
    }

    public void setReverbDelay(float f2) {
        this.attribs.reverbDelay = f2;
    }

    public void setReverbOrder(int n2) {
        this.attribs.reverbOrder = n2;
    }

    public void setDistanceFilter(int n2, double[] dArray, float[] fArray) {
        this.attribs.setDistanceFilter(n2, dArray, fArray);
    }

    public void setFrequencyScaleFactor(float f2) {
        this.attribs.frequencyScaleFactor = f2;
    }

    public void setVelocityScaleFactor(float f2) {
        this.attribs.velocityScaleFactor = f2;
    }

    public int getNumberOfChannelsUsed(int n2) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            return sample.getNumberOfChannelsUsed();
        }
        return 0;
    }

    public int getNumberOfChannelsUsed(int n2, boolean bl) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            return sample.getNumberOfChannelsUsed();
        }
        return 0;
    }

    public long getSampleDuration(int n2) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            return sample.getDuration();
        }
        return 0L;
    }

    public long getStartTime(int n2) {
        Sample sample = this.getSample(n2);
        if (sample != null) {
            return sample.getStartTime();
        }
        return 0L;
    }

    protected ArrayList getSampleList() {
        return this.samples;
    }

    public int getSampleListSize() {
        return this.samples.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(int n2) {
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            if (n2 >= 0 && n2 < this.samples.size()) {
                Sample sample = (Sample)this.samples.get(n2);
                return sample;
            }
            return null;
        }
    }

    public AuralParameters getAuralParameters() {
        return this.attribs;
    }
}

